<?php
/**
 * Default theme options.
 *
 * @package Mavix Restaurant
 */

if ( ! function_exists( 'mavix_restaurant_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
function mavix_restaurant_get_default_theme_options() {

	$mavix_restaurant_defaults = array();

	// Contact Details
	$mavix_restaurant_defaults['mavix_restaurant_show_contact_details'] 		= true;
	$mavix_restaurant_defaults['mavix_restaurant_address_one']				= esc_html__('214 West Arnold St','mavix-restaurant');
	$mavix_restaurant_defaults['mavix_restaurant_address_two']				= esc_html__('New York, NY 10002','mavix-restaurant');
	$mavix_restaurant_defaults['mavix_restaurant_phone_number']				= esc_html__('(007) 123 456 7890','mavix-restaurant');
	$mavix_restaurant_defaults['mavix_restaurant_opening_time']				= esc_html__('Mon-Fri 10:00am-7:30pm','mavix-restaurant');
	$mavix_restaurant_defaults['mavix_restaurant_email_id']					= esc_html__('info@example.com','mavix-restaurant');
	$mavix_restaurant_defaults['mavix_restaurant_support_text']				= esc_html__('24 X 7 online support','mavix-restaurant');

	// Menu
	$mavix_restaurant_defaults['mavix_restaurant_show_menu_button'] 			= true;
	$mavix_restaurant_defaults['mavix_restaurant_menu_button_text']			= esc_html__('Book A Table','mavix-restaurant');
	$mavix_restaurant_defaults['mavix_restaurant_menu_button_url']			= esc_url('#','mavix-restaurant');

	//General Section
	$mavix_restaurant_defaults['readmore_text']					= esc_html__('Read More','mavix-restaurant');
	$mavix_restaurant_defaults['your_latest_posts_title']			= esc_html__('Blog','mavix-restaurant');
	$mavix_restaurant_defaults['excerpt_length']					= 10;
	$mavix_restaurant_defaults['layout_options_blog']				= 'no-sidebar';
	$mavix_restaurant_defaults['layout_options_archive']			= 'no-sidebar';
	$mavix_restaurant_defaults['layout_options_page']				= 'no-sidebar';	
	$mavix_restaurant_defaults['layout_options_single']			= 'right-sidebar';	

	//Footer section 		
	$mavix_restaurant_defaults['copyright_text']					= esc_html__( 'Copyright &copy; All rights reserved.', 'mavix-restaurant' );

	// Pass through filter.
	$mavix_restaurant_defaults = apply_filters( 'mavix_restaurant_filter_default_theme_options', $mavix_restaurant_defaults );
	return $mavix_restaurant_defaults;
}

endif;

/**
*  Get theme options
*/
if ( ! function_exists( 'mavix_restaurant_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function mavix_restaurant_get_option( $key ) {

		$mavix_restaurant_default_options = mavix_restaurant_get_default_theme_options();
		if ( empty( $key ) ) {
			return;
		}

		$mavix_restaurant_theme_options = (array)get_theme_mod( 'theme_options' );
		$mavix_restaurant_theme_options = wp_parse_args( $mavix_restaurant_theme_options, $mavix_restaurant_default_options );

		$value = null;

		if ( isset( $mavix_restaurant_theme_options[ $key ] ) ) {
			$value = $mavix_restaurant_theme_options[ $key ];
		}

		return $value;

	}

endif;